﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerCoreSubsystem.h"
#include "GpLoggerBridgeSubsystem.generated.h"

class IGpLoggerNativeBridge;

using FGpLoggerBridgePtr = TSharedPtr<IGpLoggerNativeBridge>;

// Caution: Situations with multiple GameInstance are not considered
UCLASS()
class UGpLoggerBridgeSubsystem : public UGpLoggerCoreSubsystem
{
    GENERATED_BODY()
    
public:
    static FGpLoggerBridgePtr GetBridge()
    {
        return NativeBridge;
    }
    
protected:
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;

    virtual UClass* GetLoggerClass() const override;
    virtual UClass* GetInstanceLoggerClass() const override;
    
private:
    static FGpLoggerBridgePtr NativeBridge;
};
