﻿#include "GpLoggerBridgeSubsystem.h"

#include "GpBridgeLogger.h"
#include "GpLoggerPlatformDefines.h"

FGpLoggerBridgePtr UGpLoggerBridgeSubsystem::NativeBridge = nullptr;

void UGpLoggerBridgeSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);

    if (NativeBridge.IsValid() == false)
    {
        NativeBridge = MakeShared<FGpLoggerPlatformBridge>();
    }
}

void UGpLoggerBridgeSubsystem::Deinitialize()
{
    Super::Deinitialize();
    
    if (NativeBridge.IsValid())
    {
        NativeBridge = nullptr;
    }
}

UClass* UGpLoggerBridgeSubsystem::GetLoggerClass() const
{
    return UGpBridgeLogger::StaticClass();
}

UClass* UGpLoggerBridgeSubsystem::GetInstanceLoggerClass() const
{
    return UGpBridgeInstanceLogger::StaticClass();
}
