﻿using System;
using System.IO;
using UnrealBuildTool;

public class GpLoggerBridge : ModuleRules
{
    public GpLoggerBridge(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
                "Projects",
                "Json",
                "JsonUtilities",
                "GpLogger",
                "GpLoggerCore",
            }
        );
        
        PrivateIncludePaths.Add(Path.Combine(ModuleDirectory, "Private/Internal"));
        
        if (Target.Platform == UnrealTargetPlatform.Android)
        {
            PrivateIncludePaths.Add(Path.Combine(ModuleDirectory, "Private/Internal/Android"));
            
            var pluginPath = Utils.MakePathRelativeTo(ModuleDirectory, Target.RelativeEnginePath);
            AdditionalPropertiesForReceipt.Add("AndroidPlugin", Path.Combine(pluginPath, "GpLogger_Android_UPL.xml"));
        }
        else if (Target.Platform == UnrealTargetPlatform.IOS)
        {
            PrivateIncludePaths.Add(Path.Combine(ModuleDirectory, "Private/Internal/iOS"));

            string iOSPluginPath = Path.GetFullPath(Path.Combine(ModuleDirectory, "ThirdParty/iOS"));

            PublicAdditionalFrameworks.Add(
                new Framework(
                    "GpLoggerPlugin",
                    Path.Combine(iOSPluginPath, "GpLoggerPlugin.embeddedframework.zip")
                )
            );

            PublicAdditionalFrameworks.Add(
                new Framework(
                    "GpLoggerUnrealPlugin",
                    Path.Combine(iOSPluginPath, "GpLoggerUnrealPlugin.embeddedframework.zip")
                )
            );

            PublicAdditionalFrameworks.Add(
                new Framework(
                    "NHNCloudCommon",
                    Path.Combine(iOSPluginPath, "NHNCloudCommon.embeddedframework.zip")
                )
            );

            PublicAdditionalFrameworks.Add(
                new Framework(
                    "NHNCloudCore",
                    Path.Combine(iOSPluginPath, "NHNCloudCore.embeddedframework.zip")
                )
            );

            PublicAdditionalFrameworks.Add(
                new Framework(
                    "NHNCloudLogger",
                    Path.Combine(iOSPluginPath, "NHNCloudLogger.embeddedframework.zip")
                )
            );
        }
        else
        {
            Console.WriteLine("[GpLoggerBridge] {0} is not supported.", Target.Platform);
        }
    }
}