﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerConfiguration.h"
#include "GpLoggerEventListener.h"
#include "GpLoggerCrashData.h"
#include "GpLoggerSubsystem.generated.h"

class UGpLoggerInstance;

UCLASS(Abstract)
class GPLOGGER_API UGpLoggerSubsystem : public UGameInstanceSubsystem
{
    GENERATED_BODY()
    
public:
    virtual void Initialize(const FGpLoggerConfiguration& Configuration)
    PURE_VIRTUAL(UGpLoggerSubsystem::Initialize,);

    virtual void Debug(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerSubsystem::Debug,);
    
    virtual void Info(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerSubsystem::Info,);
    
    virtual void Warn(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerSubsystem::Warn,);
    
    virtual void Error(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerSubsystem::Error,);
    
    virtual void Fatal(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerSubsystem::Fatal,);
    
    virtual void SetUserField(const FString& Key, const FString& Value)
    PURE_VIRTUAL(UGpLoggerSubsystem::SetUserField,);
    
    virtual void SetLoggerListener(const FGpLoggerEventListener& Listener)
    PURE_VIRTUAL(UGpLoggerSubsystem::SetLoggerListener,);
    
    virtual void SetCrashListener(const FGpLoggerCrashListener& FilterDelegate)
    PURE_VIRTUAL(UGpLoggerSubsystem::SetCrashListener,);
    
    virtual void SetGameUserId(const FString& UserId)
    PURE_VIRTUAL(UGpLoggerSubsystem::SetGameUserId,);
    
    virtual UGpLoggerInstance* NewInstance(const FString& Appkey, EGpLoggerServiceZone ServiceZone)
    PURE_VIRTUAL(UGpLoggerSubsystem::NewInstance, return nullptr;);
    
protected:
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    // ~USubsystem interface
};
