#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "GpLoggerInstance.generated.h"

UCLASS(Abstract)
class GPLOGGER_API UGpLoggerInstance : public UObject
{
    GENERATED_BODY()
    
public:
    virtual void Debug(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerInstance::Debug,);
    
    virtual void Info(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerInstance::Info,);
    
    virtual void Warn(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerInstance::Warn,);
    
    virtual void Error(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerInstance::Error,);
    
    virtual void Fatal(const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpLoggerInstance::Fatal,);

    virtual void SetUserField(const FString& Key, const FString& Value)
    PURE_VIRTUAL(UGpLoggerInstance::SetUserField,);
};