﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerTypes.h"
#include "GpLoggerEventListener.generated.h"

DECLARE_DELEGATE_OneParam(FGpLoggerSuccessDelegate, const FGpLogEntry&);
DECLARE_DELEGATE_OneParam(FGpLoggerSaveDelegate, const FGpLogEntry&);
DECLARE_DELEGATE_TwoParams(FGpLoggerFilterDelegate, const FGpLogEntry&, const FGpLogFilter&);
DECLARE_DELEGATE_TwoParams(FGpLoggerErrorDelegate, const FGpLogEntry&, const FString&);

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLoggerEventListener
{
    GENERATED_BODY()

    FGpLoggerSuccessDelegate OnSuccessDelegate;
    FGpLoggerSaveDelegate OnSaveDelegate;
    FGpLoggerFilterDelegate OnFilterDelegate;
    FGpLoggerErrorDelegate OnErrorDelegate;
};