#pragma once

#include "CoreMinimal.h"
#include "GpLoggerTypes.h"
#include "GpLoggerCrashData.generated.h"

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLoggerCrashData
{
    GENERATED_BODY()

    UPROPERTY()
    EGpLogLevel LogLevel;

    UPROPERTY()
    FString Condition;
    
    UPROPERTY()
    FString StackTrace;
};

DECLARE_DELEGATE_RetVal_OneParam(bool, FGpLoggerCrashFilterDelegate, const FGpLoggerCrashData&);

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLoggerCrashListener
{
    GENERATED_BODY()

    FGpLoggerCrashFilterDelegate OnCrashFilterDelegate;
};