#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.7.1 effective-4.1.50 (swiftlang-5.7.1.135.3 clang-1400.0.29.51)
#ifndef GTMAPPAUTH_SWIFT_H
#define GTMAPPAUTH_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wduplicate-method-match"
#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT noexcept
#endif
#else
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT 
#endif
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_CXX_INT_DEFINED)
#define SWIFT_CXX_INT_DEFINED
namespace swift {
using Int = ptrdiff_t;
using UInt = size_t;
}
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import CoreFoundation;
@import Foundation;
@import GTMSessionFetcher;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="GTMAppAuth",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
@class OIDAuthState;
@class NSString;
@protocol GTMAuthSessionDelegate;
@protocol GTMSessionFetcherServiceProtocol;
@class NSCoder;
@class NSMutableURLRequest;
@class NSURLRequest;
@class OIDServiceConfiguration;

/// An implementation of the <code>GTMFetcherAuthorizationProtocol</code> protocol for the AppAuth library.
/// Enables you to use AppAuth with the GTM Session Fetcher library.
SWIFT_CLASS_NAMED("AuthSession")
@interface GTMAuthSession : NSObject <NSSecureCoding, GTMSessionFetcherAuthorizer>
/// The AppAuth authentication state.
@property (nonatomic, readonly, strong) OIDAuthState * _Nonnull authState;
/// Service identifier, for example “Google”; not used for authentication.
/// The provider name is just for allowing stored authorization to be associated with the
/// authorizing service.
@property (nonatomic, readonly, copy) NSString * _Nullable serviceProvider;
/// User ID from the ID Token.
/// Never send this value to your backend as an authentication token, rather send an ID Token and
/// validate it.
@property (nonatomic, readonly, copy) NSString * _Nullable userID;
/// The user email.
@property (nonatomic, readonly, copy) NSString * _Nullable userEmail;
/// Email verified status; not used for authentication.
@property (nonatomic, readonly) BOOL userEmailIsVerified;
/// For development only, allow authorization of non-SSL requests, allowing transmission of the
/// bearer token unencrypted.
@property (nonatomic) BOOL shouldAuthorizeAllRequests;
/// Delegate of the <code>AuthSession</code>.
@property (nonatomic, weak) id <GTMAuthSessionDelegate> _Nullable delegate;
/// The fetcher service.
@property (nonatomic, weak) id <GTMSessionFetcherServiceProtocol> _Nullable fetcherService;
/// Creates a new <code>AuthSession</code> using the given <code>OIDAuthState</code> from AppAuth.
/// \param authState The authorization state.
///
- (nonnull instancetype)initWithAuthState:(OIDAuthState * _Nonnull)authState;
/// Creates a new <code>AuthSession</code> using the given <code>OIDAuthState</code> from AppAuth.
/// \param authState The authorization state.
///
/// \param serviceProvider An optional string to describe the service.
///
/// \param userID An optional string of the user ID.
///
/// \param userEmail An optional string of the user’s email address.
///
/// \param userEmailIsVerified An optional string representation of a boolean to indicate
/// that the email address has been verified. Pass “true” or “false”.
///
- (nonnull instancetype)initWithAuthState:(OIDAuthState * _Nonnull)authState serviceProvider:(NSString * _Nullable)serviceProvider userID:(NSString * _Nullable)userID userEmail:(NSString * _Nullable)userEmail userEmailIsVerified:(NSString * _Nullable)userEmailIsVerified OBJC_DESIGNATED_INITIALIZER;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL supportsSecureCoding;)
+ (BOOL)supportsSecureCoding SWIFT_WARN_UNUSED_RESULT;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
/// Adds an authorization header to the given request, using the authorization state. Refreshes
/// the access token if needed.
/// The completion handler is scheduled on the main thread, unless the <code>callbackQueue</code> property is
/// set on the <code>fetcherService</code> in which case the handler is scheduled on that queue.
/// \param request The request to authorize.
///
/// \param handler The block that is called after authorizing the request is attempted.  If <code>error</code>
/// is non-nil, the authorization failed.  Errors in the domain <code>OIDOAuthTokenErrorDomain</code>
/// indicate that the authorization itself is invalid, and will need to be re-obtained from
/// the user.  <code>AuthSession.Error</code>s indicate other unrecoverable errors. Errors in other
/// domains may indicate a transitive error condition such as a network error, and typically
/// you do not need to reauthenticate the user on such errors.
///
- (void)authorizeRequest:(NSMutableURLRequest * _Nullable)request completionHandler:(void (^ _Nonnull)(NSError * _Nullable))handler;
/// Adds an authorization header to the given request, using the authorization state. Refreshes
/// the access token if needed.
/// \param request The request to authorize.
///
/// \param delegate The delegate to receive the callback.
///
/// \param selector The <code>Selector</code> to call upon the provided <code>delegate</code>.
///
- (void)authorizeRequest:(NSMutableURLRequest * _Nullable)request delegate:(id _Nonnull)delegate didFinishSelector:(SEL _Nonnull)selector;
/// Stops authorization for all pending requests.
- (void)stopAuthorization;
/// Stops authorization for the provided <code>URLRequest</code> if it is queued for authorization.
- (void)stopAuthorizationForRequest:(NSURLRequest * _Nonnull)request;
/// Returns <code>true</code> if the provided <code>URLRequest</code> is currently in the process of, or is in the queue
/// for, authorization.
- (BOOL)isAuthorizingRequest:(NSURLRequest * _Nonnull)request SWIFT_WARN_UNUSED_RESULT;
/// Returns <code>true</code> if the provided <code>URLRequest</code> has the “Authorization” header field.
- (BOOL)isAuthorizedRequest:(NSURLRequest * _Nonnull)request SWIFT_WARN_UNUSED_RESULT;
/// Returns <code>true</code> if the authorization state is currently valid.
/// This doesn’t guarantee that a request will get a valid authorization, as the authorization
/// state could become invalid on the next token refresh.
@property (nonatomic, readonly) BOOL canAuthorize;
/// Whether or not this authorization is prime for refresh.
/// If <code>true</code>, calling this method will <code>setNeedsTokenRefresh()</code> on the <code>OIDAuthState</code> instance
/// property.
///
/// returns:
/// <code>false</code> if the <code>OIDAuthState</code>’s <code>refreshToken</code> is nil. <code>true</code> otherwise.
- (BOOL)primeForRefresh SWIFT_WARN_UNUSED_RESULT;
/// Convenience method to return an @c OIDServiceConfiguration for Google.
///
/// returns:
/// An <code>OIDServiceConfiguration</code> object setup with Google OAuth endpoints.
+ (OIDServiceConfiguration * _Nonnull)configurationForGoogle SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_DEPRECATED_MSG("-init is unavailable");
@end


@interface GTMAuthSession (SWIFT_EXTENSION(GTMAppAuth))
@end

/// Error codes associated with cases from <code>AuthSession.Error</code>.
/// The cases for this enumeration are backed by integer raw values and are used to fill out the
/// <code>errorCode</code> for the <code>NSError</code> representation of <code>AuthSession.Error</code>.
typedef SWIFT_ENUM_NAMED(NSInteger, GTMAuthSessionErrorCode, "ErrorCode", open) {
  GTMAuthSessionErrorCodeCannotAuthorizeRequest = 0,
  GTMAuthSessionErrorCodeAccessTokenEmptyForRequest = 1,
};


/// Methods defining the <code>AuthSession</code>’s delegate.
SWIFT_PROTOCOL_NAMED("AuthSessionDelegate")
@protocol GTMAuthSessionDelegate
@optional
/// Used to supply additional parameters on token refresh.
/// \param authSession The <code>AuthSession</code> needing additional token refresh parameters.
///
///
/// returns:
/// An optional <code>[String: String]</code> supplying the additional token refresh parameters.
- (NSDictionary<NSString *, NSString *> * _Nullable)additionalTokenRefreshParametersForAuthSession:(GTMAuthSession * _Nonnull)authSession SWIFT_WARN_UNUSED_RESULT;
/// A method notifying the delegate that the authorization request failed.
/// Use this method to examine the error behind the failed authorization request and supply a
/// customized error created asynchronously that specifies whatever context is needed.
/// \param authSession The <code>AuthSession</code> whose authorization request failed.
///
/// \param originalError The original <code>Error</code> associated with the failure.
///
/// \param completion An escaping closure to pass back the updated error.
///
- (void)updateErrorForAuthSession:(GTMAuthSession * _Nonnull)authSession originalError:(NSError * _Nonnull)originalError completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
@end


/// Represents the operations needed to provide <code>AuthSession</code> storage.
SWIFT_PROTOCOL_NAMED("AuthSessionStore")
@protocol GTMAuthSessionStore
/// Saves the provided <code>AuthSession</code>.
/// \param authSession An instance of <code>AuthSession</code> to save.
///
///
/// throws:
/// Any error that may arise during the save.
- (BOOL)saveAuthSession:(GTMAuthSession * _Nonnull)authSession error:(NSError * _Nullable * _Nullable)error;
/// Removes the stored <code>AuthSession</code>.
///
/// throws:
/// Any error that may arise during the removal.
- (BOOL)removeAuthSessionWithError:(NSError * _Nullable * _Nullable)error;
/// Retrieves the stored <code>AuthSession</code>.
///
/// throws:
/// Any error that may arise during the retrieval.
- (GTMAuthSession * _Nullable)retrieveAuthSessionWithError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

@class NSURL;

/// Class to support serialization and deserialization of <code>AuthSession</code> in the format used by
/// GTMOAuth2.
/// The methods of this class are capable of serializing and deserializing auth objects in a way
/// compatible with the serialization in <code>GTMOAuth2ViewControllerTouch</code> and
/// <code>GTMOAuth2WindowController</code> in GTMOAuth2.
SWIFT_CLASS_NAMED("GTMOAuth2Compatibility")
@interface GTMOAuth2Compatibility : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_DEPRECATED_MSG("-init is unavailable");
/// Encodes the given <code>AuthSession</code> in a GTMOAuth2 compatible persistence string using URL param
/// key/value encoding.
/// \param authSession The <code>AuthSession</code> to serialize in GTMOAuth2 format.
///
///
/// returns:
/// A <code>String?</code> representing the GTMOAuth2 persistence representation of the
/// authorization object.
+ (NSString * _Nullable)persistenceResponseStringForAuthSession:(GTMAuthSession * _Nonnull)authSession SWIFT_WARN_UNUSED_RESULT;
/// Creates an <code>AuthSession</code> from the provided persistence string.
/// \param persistenceString The <code>String</code> representing the <code>AuthSession</code> to create.
///
/// \param tokenURL The <code>URL</code> to use when creating the <code>AuthSession</code>.
///
/// \param redirectURI The <code>String</code> URI to use for the <code>AuthSession</code>.
///
/// \param clientID The <code>String</code> client ID for the <code>AuthSession</code>.
///
/// \param clientSecret The optional <code>String</code> for the <code>AuthSession</code>.
///
///
/// throws:
/// <code>KeychainStore.Error.failedToConvertRedirectURItoURL</code> if <code>redirectURI</code> cannot be
/// converted to a <code>URL</code>.
///
/// returns:
/// An instance of <code>AuthSession</code> if successful.
+ (GTMAuthSession * _Nullable)authSessionForPersistenceString:(NSString * _Nonnull)persistenceString tokenURL:(NSURL * _Nonnull)tokenURL redirectURI:(NSString * _Nonnull)redirectURI clientID:(NSString * _Nonnull)clientID clientSecret:(NSString * _Nullable)clientSecret error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end


/// The Keychain attribute used to configure the way the keychain stores your items.
SWIFT_CLASS_NAMED("KeychainAttribute")
@interface GTMKeychainAttribute : NSObject
/// Creates an instance of <code>KeychainAttribute</code> whose attribute is set to
/// <code>.useDataProtectionKeychain</code>.
///
/// returns:
/// An instance of <code>KeychainAttribute</code>.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) GTMKeychainAttribute * _Nonnull useDataProtectionKeychain SWIFT_AVAILABILITY(watchos,introduced=6.0) SWIFT_AVAILABILITY(tvos,introduced=13.0) SWIFT_AVAILABILITY(ios,introduced=13.0) SWIFT_AVAILABILITY(macos,introduced=10.15);)
+ (GTMKeychainAttribute * _Nonnull)useDataProtectionKeychain SWIFT_WARN_UNUSED_RESULT;
/// Creates an instance of <code>KeychainAttribute</code> whose attribute is set to <code>.accessGroup</code>.
/// \param name The <code>String</code> name for the access group.
///
///
/// returns:
/// An instance of <code>KeychainAttribute</code>.
+ (GTMKeychainAttribute * _Nonnull)keychainAccessGroupWithName:(NSString * _Nonnull)name SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_DEPRECATED_MSG("-init is unavailable");
@end

@class NSData;

/// A protocol defining the helper API for interacting with the Keychain.
SWIFT_PROTOCOL_NAMED("KeychainHelper")
@protocol GTMKeychainHelper
@property (nonatomic, readonly, copy) NSString * _Nonnull accountName;
@property (nonatomic, readonly, copy) NSSet<GTMKeychainAttribute *> * _Nonnull keychainAttributes;
- (nonnull instancetype)initWithKeychainAttributes:(NSSet<GTMKeychainAttribute *> * _Nonnull)keychainAttributes;
- (NSDictionary<NSString *, id> * _Nonnull)keychainQueryForService:(NSString * _Nonnull)service SWIFT_WARN_UNUSED_RESULT;
- (NSString * _Nullable)passwordForService:(NSString * _Nonnull)service error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (NSData * _Nullable)passwordDataForService:(NSString * _Nonnull)service error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (BOOL)removePasswordForService:(NSString * _Nonnull)service error:(NSError * _Nullable * _Nullable)error;
- (BOOL)setPassword:(NSString * _Nonnull)password forService:(NSString * _Nonnull)service error:(NSError * _Nullable * _Nullable)error;
- (BOOL)setPassword:(NSString * _Nonnull)password forService:(NSString * _Nonnull)service accessibility:(CFTypeRef _Nonnull)accessibility error:(NSError * _Nullable * _Nullable)error;
- (BOOL)setPasswordWithData:(NSData * _Nonnull)data forService:(NSString * _Nonnull)service accessibility:(CFTypeRef _Nullable)accessibility error:(NSError * _Nullable * _Nullable)error;
@end


/// A helper providing a concrete implementation for saving and loading auth data to the keychain.
SWIFT_CLASS_NAMED("KeychainStore")
@interface GTMKeychainStore : NSObject <GTMAuthSessionStore>
/// The helper wrapping keychain access.
@property (nonatomic, readonly, strong) id <GTMKeychainHelper> _Nonnull keychainHelper;
/// The name for the item to save in, retrieve, or remove from the keychain.
@property (nonatomic, copy) NSString * _Nonnull itemName;
/// Attributes that configure the behavior of the keychain.
@property (nonatomic, copy) NSSet<GTMKeychainAttribute *> * _Nonnull keychainAttributes;
/// An initializer for testing to create an instance of this keychain wrapper with a given helper.
/// \param itemName The <code>String</code> name for the credential to store in the keychain.
///
/// \param keychainAttributes A <code>Set</code> of <code>KeychainAttribute</code> to use with the keychain.
///
- (nonnull instancetype)initWithItemName:(NSString * _Nonnull)itemName keychainAttributes:(NSSet<GTMKeychainAttribute *> * _Nonnull)keychainAttributes;
/// An initializer for testing to create an instance of this keychain wrapper with a given helper.
/// note:
/// The <code>KeychainHelper</code>’s <code>keychainAttributes</code> are used if present.
/// \param itemName The <code>String</code> name for the credential to store in the keychain.
///
/// \param keychainHelper An instance conforming to <code>KeychainHelper</code>.
///
- (nonnull instancetype)initWithItemName:(NSString * _Nonnull)itemName keychainHelper:(id <GTMKeychainHelper> _Nonnull)keychainHelper;
/// An initializer for testing to create an instance of this keychain wrapper with a given helper.
/// \param itemName The <code>String</code> name for the credential to store in the keychain.
///
/// \param keychainAttributes A <code>Set</code> of <code>KeychainAttribute</code> to use with the keychain.
///
/// \param keychainHelper An instance conforming to <code>KeychainHelper</code>.
///
- (nonnull instancetype)initWithItemName:(NSString * _Nonnull)itemName keychainAttributes:(NSSet<GTMKeychainAttribute *> * _Nonnull)keychainAttributes keychainHelper:(id <GTMKeychainHelper> _Nonnull)keychainHelper OBJC_DESIGNATED_INITIALIZER;
/// An initializer for to create an instance of this keychain wrapper.
/// \param itemName The <code>String</code> name for the credential to store in the keychain.
///
- (nonnull instancetype)initWithItemName:(NSString * _Nonnull)itemName;
- (BOOL)saveAuthSession:(GTMAuthSession * _Nonnull)authSession error:(NSError * _Nullable * _Nullable)error;
/// Saves the provided <code>AuthSession</code> using the provided item name.
/// \param authSession An instance of <code>AuthSession</code> to save.
///
/// \param itemName A <code>String</code> name to use for the save that is different than the name given during
/// initialization.
///
///
/// throws:
/// Any error that may arise during the save.
- (BOOL)saveAuthSession:(GTMAuthSession * _Nonnull)authSession withItemName:(NSString * _Nonnull)itemName error:(NSError * _Nullable * _Nullable)error;
/// Removes the stored <code>AuthSession</code> matching the provided item name.
/// \param itemName A <code>String</code> name to use for the removal different than what was given during
/// initialization.
///
///
/// throws:
/// Any error that may arise during the removal.
- (BOOL)removeAuthSessionWithItemName:(NSString * _Nonnull)itemName error:(NSError * _Nullable * _Nullable)error;
- (BOOL)removeAuthSessionWithError:(NSError * _Nullable * _Nullable)error;
/// Retrieves the stored <code>AuthSession</code> matching the provided item name.
/// \param itemName A <code>String</code> name for the item to retrieve different than what was given during
/// initialization.
///
///
/// throws:
/// Any error that may arise during the retrieval.
- (GTMAuthSession * _Nullable)retrieveAuthSessionWithItemName:(NSString * _Nonnull)itemName error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
- (GTMAuthSession * _Nullable)retrieveAuthSessionWithError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Attempts to create an <code>AuthSession</code> from stored data in GTMOAuth2 format.
/// \param tokenURL The OAuth token endpoint URL.
///
/// \param redirectURI The OAuth redirect URI used when obtaining the original authorization.
///
/// \param clientID The OAuth client ID.
///
/// \param clientSecret The OAuth client secret.
///
///
/// throws:
/// Any error arising from the <code>AuthSession</code> creation.
///
/// returns:
/// An <code>AuthSession</code> object.
- (GTMAuthSession * _Nullable)retrieveAuthSessionInGTMOAuth2FormatWithTokenURL:(NSURL * _Nonnull)tokenURL redirectURI:(NSString * _Nonnull)redirectURI clientID:(NSString * _Nonnull)clientID clientSecret:(NSString * _Nullable)clientSecret error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Attempts to create a <code>AuthSession</code> from data stored in a GTMOAuth2 format.
/// Uses Google OAuth provider information.
/// \param clientID The OAuth client id.
///
/// \param clientSecret The OAuth client secret.
///
///
/// throws:
/// Any error arising from the <code>AuthSession</code> creation.
///
/// returns:
/// An <code>AuthSession</code> object, or nil.
- (GTMAuthSession * _Nullable)retrieveAuthSessionForGoogleInGTMOAuth2FormatWithClientID:(NSString * _Nonnull)clientID clientSecret:(NSString * _Nonnull)clientSecret error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Saves the <code>AuthSession</code> in a GTMOAuth2 compatible manner.
/// \param authSession The <code>AuthSession</code> to save.
///
///
/// throws:
/// Any error that may arise during the retrieval.
- (BOOL)saveWithGTMOAuth2FormatForAuthSession:(GTMAuthSession * _Nonnull)authSession error:(NSError * _Nullable * _Nullable)error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_DEPRECATED_MSG("-init is unavailable");
@end


@interface GTMKeychainStore (SWIFT_EXTENSION(GTMAppAuth))
@end

/// Error codes associated with cases from <code>KeychainStore.Error</code>.
/// The cases for this enumeration are backed by integer raw values and are used to fill out the
/// <code>errorCode</code> for the <code>NSError</code> representation of <code>KeychainStore.Error</code>.
typedef SWIFT_ENUM_NAMED(NSInteger, GTMKeychainStoreErrorCode, "ErrorCode", open) {
  GTMKeychainStoreErrorCodeUnhandled = 0,
  GTMKeychainStoreErrorCodePasswordNotFound = 1,
  GTMKeychainStoreErrorCodeNoService = 2,
  GTMKeychainStoreErrorCodeUnexpectedPasswordData = 3,
  GTMKeychainStoreErrorCodeFailedToCreateResponseStringFromAuthSession = 4,
  GTMKeychainStoreErrorCodeFailedToConvertRedirectURItoURL = 5,
  GTMKeychainStoreErrorCodeFailedToConvertAuthSessionToData = 6,
  GTMKeychainStoreErrorCodeFailedToConvertKeychainDataToAuthSession = 7,
  GTMKeychainStoreErrorCodeFailedToDeletePassword = 8,
  GTMKeychainStoreErrorCodeFailedToDeletePasswordBecauseItemNotFound = 9,
  GTMKeychainStoreErrorCodeFailedToSetPassword = 10,
};

#endif
#if defined(__cplusplus)
#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
